/* Example of a syndication feed reader using the Project Rome API
 * current version: rome1.0.jar
 * You need to implement this API plus the JDOM API
 * jdom.jar  ,   you can find this at jdom.org
 */

import java.net.URL;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedOutput;
/*This is the Bean interface for all types of feeds.*/
import com.sun.syndication.io.SyndFeedInput;
/*Parses an XML document(File, InputStream, Reader, W3C SAX InputSource,W3C DOM Document or JDom DOcument) into an WireFeed (RSS/Atom).*/
import com.sun.syndication.io.XmlReader;
/*Character stream that handles (or at least attemtps to)
 * all the necessary Voodo to figure out the charset
 * encoding of the XML document within the stream.*/

public class FeedReader1 {

    String n = "http://rss.orf.at/fm4.xml";

    public void getfeed() {
        boolean ok = false;
         try {
                URL feedUrl = new URL(n);/*creates a string with the URL*/

                SyndFeedInput input = new SyndFeedInput();/*new input object*/
                SyndFeed feed = input.build(new XmlReader(feedUrl));/*reads feed from URL and puts it into feed*/

                System.out.println(feed);/*outputs file to system*/

                SyndFeedOutput output = new SyndFeedOutput();     // Tree Output of the feed 
                output.output(feed,new PrintWriter(System.out));

                ok = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("ERROR: "+ex.getMessage());
            }
        

        if (!ok) {
            System.out.println();
            System.out.println("FeedReader reads and prints any RSS/Atom feed type.");
            System.out.println("The first parameter must be the URL of the feed to read.");
            System.out.println();
        }
    }

}